<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Ads;
use Hash;
use DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Mail;



class AccountController extends Controller
{

    public function getAccountList(Request $request)
    {
        $getUsers =  User::all();

        return view('accounts.index')->with(['accounts' => $getUsers]);
    }

    public function getAccountListAjax(Request $request): \Illuminate\Http\JsonResponse
    {
        $getUsers =  User::all();

        return response()->json(['data' => $getUsers]);
    }

    public function addAccount(Request $request)
    {
        if($request->is('api/*')){

            $res = array();

            $validator = Validator::make($request->all(), [
                "email" =>  "required",
                "password" =>   "required",
                "firstname" => "required",
                "lastname" => "required",
            ]);
            if ($validator->fails()) {
                $messages = $validator->messages();
                $return_message = array();
                foreach ($messages->getmessages() as $key => $message) {
                    $return_message[] = implode(",", $message);
                };
                $response['status'] = 'error';
                $response['message'] = implode(",", $return_message);
                return $response;
            }
            $inputs = $request->all();
            extract($inputs);

            $email = $request->get('email');

            $check_email = User::where('email', $email)->first();
            if ($check_email) {
                $res['status'] = 'error';
                $res['message'] = 'This email already exits';
                return $res;
            }

            $addAccount = User::create([
                'email' => isset($request->email) ? $request->email : "",
                'password' => isset($request->password) ? Hash::make($request->password) : "",
                'firstname' => isset($request->firstname) ? $request->firstname : "",
                'lastname' => isset($request->lastname) ? $request->lastname : "",
                'zip_code' => isset($request->zip_code) ? $request->zip_code : "",
                'user_type' => 0
            ]);
            if($addAccount){
                $res['status'] = 'success';
                $res['message'] = 'Your account created successfully.';
                $res['user'] = $addAccount;
            }else {
                $res['status'] = 'error';
                $res['message'] = 'Something went wrong while creating account, Please try again or later.';
            }

            return $res;
        }else{
            $validate = $request->validate([
                'email' => "required",
                'password' => "required",
                'first_name' => "required",
                'last_name' => "required",
            ]);

            extract($request->all());

            $addAccount = User::create([
                'email' => isset($request->email) ? $email : "",
                'password' => isset($request->password) ? Hash::make($password) : "",
                'firstname' => isset($request->first_name) ? $first_name : "",
                'lastname' => isset($request->last_name) ? $last_name : "",
                'zip_code' => isset($request->zip_code) ? $zip_code : "",
                'user_type' => 0
            ]);

            if($addAccount){
                return back()->with(["success" => config('globalMessages.account_create_success') ]);
            }else{
                return back()->with(["error" => config('globalMessages.account_create_error')]);
            }
        }
    }

    public function getAccountDetails($app_name,$user_id): \Illuminate\Http\JsonResponse
    {
        $getUserDetails = User::find($user_id);

        if($getUserDetails){
            return response()->json(["status" => "success", "message" => "", "data" => $getUserDetails]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_account_detail_error')]);
        }

    }

    public function editAccount(Request $request): \Illuminate\Http\RedirectResponse
    {

        extract($request->all());
        $account_id = isset($request->account_id) ? $account_id : "";

        $checkAccount = User::find($account_id);
        if($checkAccount){
            $checkAccount->email = isset($request->email) ? $email : "";
            $checkAccount->firstname = isset($request->first_name) ? $first_name : "";
            $checkAccount->lastname = isset($request->last_name) ? $last_name : "";
            $checkAccount->zip_code = isset($request->zip_code) ? $zip_code : "";
            $checkAccount->save();

            return back()->with(["success" => config('globalMessages.account_update_success')]);
        }else{
            return back()->with(["error" => config('globalMessages.account_update_error') ]);
        }

    }

    public function deleteAccount(Request $request): \Illuminate\Http\JsonResponse
    {
        $account_id = $request->get('account_id') ? $request->get('account_id') : "" ;
        $getUser = User::find($account_id);
        if($getUser){
            $getUser->delete();

            return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_account_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_account_error_message')]);
        }
    }

    public function devicetoken(Request $request)
    {
        $res = array();

        $validator = Validator::make($request->all(), [
            "user_id" =>  "required",
            "devicetoken" => "required"
        ]);

        if ($validator->fails()) {
            $messages = $validator->messages();
            $return_message = array();
            foreach ($messages->getmessages() as $key => $message) {
                $return_message[] = implode(",", $message);
            };
            $response['errorcode'] = 1000;
            $response['status'] = 'error';
            $response['message'] = implode(",", $return_message);
            $response['ads'] = [];
            $ads = Ads::select('*',DB::raw("CONCAT('".env('APP_URL')."/',image_path) as image_path"))->where('ads_status', 'active')->where('expiration', '>=', date('Y-m-d'))->orderBy('order_num', 'asc')->get();
            if (!$ads->IsEmpty()) {
                $response['ads'] = $ads;
            }
            return $response;
        }

        $inputs = $request->all();
        extract($inputs);

        $user_id = $request->get('user_id');

        $user = User::find($user_id);
        if ($user) {
            $user->device_token = $request->get('devicetoken') ? $request->get('devicetoken') : "";
            $user->device_type = $request->get('devicetype') ? $request->get('devicetype') : "";
            $user->update();
            $user = User::where('id', '!=', $user_id)->where('device_token', $request->get('devicetoken'))->first();
            if ($user) {
                $user->device_token = "";
                $user->save();
            }
            $res['errorcode'] = 0;
            $res['status'] = 'success';
            $res['message'] = 'User device token updated successfully.';
            $res['ads'] = [];
            $ads = Ads::select('*',DB::raw("CONCAT('".env('APP_URL')."/',image_path) as image_path"))->where('ads_status', 'active')->where('expiration', '>=', date('Y-m-d'))->orderBy('order_num', 'asc')->get();
            if (!$ads->IsEmpty()) {

                $res['ads'] = $ads;
            }
        } else {
            $res['errorcode'] = 0;
            $res['status'] = 'error';
            $res['message'] = 'user not found';
            $res['ads'] = [];
            $ads = Ads::where('ads_status', 'active')->where('expiration', '>=', date('Y-m-d'))->orderBy('order_num', 'asc')->get();
            if (!$ads->IsEmpty()) {

                $res['ads'] = $ads;
            }
        }
        return $res;
    }

    public function forgotPassword(Request $request)
    {
        $res = array();
        $validator = Validator::make($request->all(), [
            "email" =>  "required",
        ]);

        if ($validator->fails()) {
            $messages = $validator->messages();
            $return_message = array();
            foreach ($messages->getmessages() as $key => $message) {
                $return_message[] = implode(",", $message);
            };
            $response['status'] = 'error';
            $response['message'] = implode(",", $return_message);
            return $response;
        }

        $inputs = $request->all();
        extract($inputs);

        $user = User::where('email', $email)->first();
        if($user){
            $randm_number = \Str::random(6);
            $user->password = Hash::make($randm_number);
            $data = [
                'password'=> $randm_number,
            ];
            Mail::send('email-template.forgot_password_template', ['data'=>$data], function($message) use($email,$request) {
                $message->to($email)->subject('New Password for '.ucfirst(appName($request)));
                $message->from('info@pointnsavedashboard.com');
            });
            if($user->update()){
                $res['status'] = "success";
                $res['message'] = "Your new password is sent successfull to your email.";
            }else{
                $res['status'] = "error";
                $res['message'] = "User not found from this email address.";
            }
        }else{
            $res['status'] = "failure";
            $res['message'] = "User does not exist.";
        }
        return $res;
    }

    public function joinChamber(Request $request)
    {
        $res = array();
        $validator = Validator::make($request->all(), [
            "email" =>  "required",
            "name"    =>  "required",
            "businessname"    =>  "required",
            "mobile_number"    =>  "required",
            "zip_code" => "required",

        ]);

        if ($validator->fails()) {
            $messages = $validator->messages();
            $return_message = array();
            foreach ($messages->getmessages() as $key => $message) {
                $return_message[] = implode(",", $message);
            };
            $response['status'] = 'error';
            $response['message'] = implode(",", $return_message);
            return $response;
        }
        $inputs = $request->all();
        extract($inputs);


        $config_file = public_path('app-config/' . appName($request) . '/config.json');
        $decode_config_file = json_decode(file_get_contents($config_file),true);

        $data = [
          'email' => $email,
          'name' => $name,
          'businessname' => $businessname,
          'mobile_number' => $mobile_number,
          'zip_code' => $zip_code

        ];

        $headers  = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";

        // Additional headers
        $headers .= 'From: info@pointnsavedashboard.com' . "\r\n";

        // Subject
        $subject = 'Join Chamber Request from '.ucfirst(appName($request));

        // Message
        $message = "
        <p>Email: $email</p>
        <p>Name: $name</p>
        <p>Business Name: $businessname</p>
        <p>Mobile Number: $mobile_number</p>
        <p>Zip Code: $zip_code</p>
        ";

        $to = $decode_config_file['join_chamber']['to'];
//        Mail::send('email-template.join_chamber', ['data'=>$data], function($message) use($email,$request,$decode_config_file) {
//            $message->to($decode_config_file['join_chamber']['to'])->subject('Join Chamber Request from '.ucfirst(appName($request)));
//            $message->from('info@pointnsavedashboard.com');
//        });

        if(mail($to,$subject, $message, $headers)){
            $res['status']  = "success";
            $res['message']  = "Mail send successfully";
        }else{
            $res['status']  = "error";
            $res['message']  = "Error while sending mail please try again or later.";
        }

        return $res;
    }
}
