<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Ads;
use App\Models\User;
use App\Models\AdsClick;
use Illuminate\Support\Facades\Validator;
use DB;

use App\Http\Traits\AdsTraits;


class AdsController extends Controller
{

    use AdsTraits;


    public function adsList(Request $request)
    {
        $adsList = $this->getAllAds();
        $getDynamicFields = getIndexFields(Request(),'ads');
        return view('ads.index')->with(['add_ads'=>$adsList,'fields_name'=>$getDynamicFields]);
    }

    public function addAds(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|dimensions:width=760,height=190',
            'expiration' => 'required'
        ]);

        extract($request->all());
        if ($request->hasFile('image')) {
            $image_path = storeImage($request,$request->image,'ads');
        } else {
            $image_path = '';
        }

        $request->merge(['image_path' =>$image_path]);


        $new_ads = $this->createAds($request);
        if ($new_ads) {
            return back()->with(['success' => config('globalMessages.add_ads_success_message') ]);
        } else {
            return back()->with(['error' => config('globalMessages.add_ads_error_message')]);
        }
    }

    public function editAds(Request $request)
    {
        extract($request->all());

        $getAds = $this->updateAds($request);
        if($getAds){
            return back()->with(["success" => config('globalMessages.edit_ads_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.edit_ads_error') ]);
        }
    }
}
