<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Directory;
use App\Models\DirectoryCategory;
use DB;
use App\Http\Traits\DirectoryTraits;

class DirectoryController extends Controller
{
    use DirectoryTraits ;

    public function getDirectoryList(Request $request)
    {
        $res = array();
        $category_id = $request->get('category_id');

        $directory = $this->selectAllDirectory($category_id);
        if (!$directory->IsEmpty()) {
            $res['status'] = 'success';
            $res['message'] = 'directory found successfully';
            $res['data'] = $directory;
        } else {
            $res['status'] = 'error';
            $res['message'] = 'No result found for this directory';
        }
        return $res;
    }

    public function getDirectoryDetails($app_name,$directory_id)
    {
        $getDirectoryDetails = $this->getDirectoryDetail($directory_id);

        if($getDirectoryDetails){
            return response()->json(["status" => "success", "message" => "", "data" => $getDirectoryDetails]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_directory_detail_error')]);
        }
    }

    public function deleteDirectory(Request $request)
    {
        $getDirectory = $this->directoryDelete($request);
        if($getDirectory){
           return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_directory_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_directory_error_message')]);
        }
    }

}
