<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;
use DB;
use App\Http\Traits\EventTraits;

class EventController extends Controller
{

    use EventTraits;

    public function getEventList(Request $request)
    {
        
        $res = array();
        $category_id = $request->get('category_id');

        $event = $this->selectAllEvent($category_id);
        if (!$event->IsEmpty()) {
            $res['status'] = 'success';
            $res['message'] = 'event found successfully';
            $res['data'] = $event;
        } else {
            $res['status'] = 'error';
            $res['message'] = 'No result found for this event';
        }
        return $res;
    }

    public function getEventDetails($app_name,$event_id)
    {
        $getEventDetails = $this->getEventDetail($event_id);
        if($getEventDetails){
            return response()->json(["status" => "success", "message" => "", "data" => $getEventDetails]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_event_detail_error')]);
        }

    }

    public function deleteEvent(Request $request)
    {
        $getEvent = $this->eventDelete($request);
        if($getEvent){
            return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_event_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_event_error_message')]);
        }
    }

}
