<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\NewsBlogs;
use DB;
use App\Http\Traits\NewsBlogsTraits;


class NewsBlogsController extends Controller
{
    use NewsBlogsTraits ;


    public function getNewsBlogsList(Request $request)
    {
        $newsBlogs = $this->SelectAllNewsBlogs();

        return response()->json(['status' => 'success', 'message' => 'News Blogs found successfully', 'data' => $newsBlogs]);
    }

    public function getNewsBlogsDetails($app_name,$news_blogs_id)
    {
        $getNewsBlogsDetails =$this->getNewsBlogsDetail($news_blogs_id);

        if($getNewsBlogsDetails){
            return response()->json(["status" => "success", "message" => "", "data" => $getNewsBlogsDetails]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_news_blogs_detail_error')]);
        }
    }

    public function deleteNewsBlogs(Request $request)
    {
        $getNews = $this->newsBlogsDelete($request);
        if($getNews){
            return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_news_blogs_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_news_blogs_error_message')]);
        }
    }

}
