<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Resource;
use App\Models\ResourceCategory;
use DB;
use App\Http\Traits\ResourceTraits;


class ResourceController extends Controller
{
    use ResourceTraits;

    public function getResourceList (Request $request)
    {
            $res = array();

                $resource = $this->selectAllRescource($request);
                if (!$resource->IsEmpty()) {
                    $res['status'] = 'success';
                    $res['message'] = 'Resources found successfully';

                    $res['data'] = $resource;
                } else {
                    $res['status'] = 'error';
                    $res['message'] = 'Resources not found';
                }
            return $res;
    }

    public function getResourceDetails($app_name,$resource_id)
    {
        $getResourceDetails =$this->getResourceDetail($resource_id);

        if($getResourceDetails){
            return response()->json(["status" => "success", "message" => "", "data" => $getResourceDetails]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_resource_detail_error')]);
        }
    }

    public function deleteResource(Request $request)
    {
        $getResource = $this->resourceDelete($request);
        if($getResource){
            return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_resource_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_resource_error_message')]);
        }
    }
}
