<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use DB;
use Hash;
use Illuminate\Support\Facades\Validator;

class LoginController extends Controller
{

    public function indexLogin(Request $request)
    {
        $email = $request->get('email');
        $password = $request->get('password');

        if(Auth::attempt(['email' => $email,'password' => $password])){

            session()->put('user',Auth::user());
            session()->put('user_email',$email);

            return redirect(baseRedirectUrl($request).'/');
        }else{
            return back()->with(['error' => "Email or password is not valid"]);
        }
    }

    public function logout(Request $request)
    {

        Auth::logout();
        $request->session()->flush();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('app'.'/' .appName($request).'/login');
    }

    public function login(Request $request)
    {

        $res = array();

        $validator = Validator::make($request->all(), [
            "email" =>  "required",
            "password" =>   "required",
        ]);
        if ($validator->fails()) {
            $messages = $validator->messages();
            $return_message = array();
            foreach ($messages->getmessages() as $key => $message) {
                $return_message[] = implode(",", $message);
            };
            $response['status'] = 'error';
            $response['message'] = implode(",", $return_message);
            return $response;
        }

        $inputs = $request->all();
        extract($inputs);
        $email = $request->get('email');
        $password = $request->get('password');
        $device_token = $request->get('device_token');
        $device_type = $request->get('device_type');

        $user = User::select('*','device_token as devicetoken','device_type as devicetype')->where('email',$email)->first();
        if($user){
            if(Hash::check($password,$user->password)){
                $user->device_token = $device_token;
                $user->device_type = $device_type;
                $user->update();
                $res['status'] = 'success';
                $res['message'] = 'You logged in successfully';
                $res['user'] = $user;
               $res['token'] = getTokenAndRefreshToken($user->email,$password,$request);

            }else{
                $res['status'] = 'error';
                $res['message'] = 'Your Email or password is incorrect.';
            }
        }else{
            $res['status'] = 'error';
            $res['message'] = 'Your Email or password is incorrect.';
        }
        return $res;
    }

}
