<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Config;

class DatabaseConnectionChooser
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {

        $app_name = appName($request) == "" ? "" : appName($request);

        Config::set('session.path', $app_name);

        if($app_name == ""){
            return redirect('/404');
        }

        // get json config file for public path
        $config_file = public_path('app-config/' . appName($request) . '/config.json');

        // check config file is exist or not
        if(!file_exists($config_file)){
            return redirect('/404');
        }
        //decode json config file
        $decode_config_file = json_decode(file_get_contents($config_file),true);

        //set database connetion with json config file as per app
        Config::set('database.connections.mysql.database',$decode_config_file['db_config']['database']);
        Config::set('database.connections.mysql.username',$decode_config_file['db_config']['username']);
        Config::set('database.connections.mysql.password',$decode_config_file['db_config']['password']);

        return $next($request);
    }
}
