<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

/**
 * Post
 *
 * @mixin Eloquent
 */
class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id',
        'admin',
        'email',
        'password',
        'firstname',
        'lastname',
        'zip_code',
        'user_type',
        'is_member',
        'device_token',
        'device_type',
        'password_reset_token',
        'password_reset_time',
        'created_at',
        'updated_at'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'device_token',
        'device_type',
        'password_reset_token',
        'password_reset_time'
    ];


    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */

    protected $casts = [
        'id' => 'integer',
        'admin' => 'integer',
        'email' => 'string',
        'password' => 'string',
        'firstname' => 'string',
        'lastname' => 'string',
        'zip_code' => 'string',
        'user_type' => 'integer',
        'is_member' => 'integer',
        'device_token' => 'string',
        'device_type' => 'string',
        'password_reset_token' => 'string',
        'password_reset_time' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'email_verified_at' => 'datetime',
    ];
}
