@extends('layouts.app')
@section('title', $fields_name['header_title'])
@section('content')
<div class="content">
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <button type="button" class="btn btn-primary float-right open-add-modal" data-toggle="modal" data-target="#AddModal"> ADD </button>
          <h4 class="card-title">{{$fields_name['table_header_title']}}</h4>
          @if ($message = Session::get('success'))
          <div class="alert alert-success alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong>{{ $message }}</strong>
          </div>
          @endif

          @if ($message = session()->get('error'))
          <div class="alert alert-danger alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong>{{ $message }}</strong>
          </div>
          @endif
          @if (count($errors) > 0)
          <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong>Error!</strong> There were some problems with your input.
            <ul>
              @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
              @endforeach
            </ul>
          </div>
          @endif
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table" id="events-table">
              <thead class="text-primary">
                <th>#</th>
                <th>Images</th>
                <th>Title</th>
                <th>End Date</th>
                <th>Order</th>
                <th>Event Status</th>
                <th class="text-center">Action</th>
              </thead>
              <tbody>
                @foreach($events as $row)
                <tr>
                  <td>{{ $loop->iteration }}</td>
                  <td>
                    @if ($row->image_path != null && file_exists($row->image_path))
                        <img src="{{url($row->image_path)}}" height="75" />
                    @else
                    <span>-</span>
                     @endif
                 </td>
                  <td>{{ $row->title }}</td>
                  <td>{{ \Carbon\Carbon::parse($row->end_date)->format('d-M-Y')}}</td>
                  <td>{{ $row->order_num }}</td>
                  <td>@if ($row->event_status == 'active')
                          Active
                      @else
                         In-Active
                      @endif
                </td>

                  <td class="text-center">
                    <div class="dropdown">
                      <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        Action
                      </button>
                      <div class="dropdown-menu">
                          <a class="dropdown-item open-edit-modal"  data-id="{{ $row->id }}" href="javascript:void(0)">Edit</a>
                          <a class="dropdown-item open-edit-delete" data-id="{{ $row->id }}" href="javascript:void(0)">Delete</a>
                    </div>
                    </div>
                  </td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Add modal -->
@include('event.modal.add-event-modal')
<!-- edit Modal -->
@include('event.modal.edit-event-modal')

@endsection

@section('script-section')

    <script>
        $(document).ready(function() {
            $('#events-table').DataTable();

            $('.open-add-modal').on('click',function(){
                $('#AddModal').find('form').trigger('reset');
                let $alerts = $('#AddModal');
                $alerts.validate().resetForm();
                $alerts.find('.error').removeClass('error');
            });
        });
        $('#addform').validate({
                rules: {
                    image: {
                        required: true,
                    },
                    title: {
                        required: true,
                    },
                    start_end_time: {
                        required: true,
                    },
                    phone: {
                        maxlength: 14,
                        numericdashe: true
                    },
                    url: {
                        complete_url: true
                    },
                       seats: {
                        complete_url: true
                    }
                },
                messages: {
                    image: {
                        required: "{{ config('globalMessages.required_message.image') }}",
                    },
                    title: {
                        required: "{{ config('globalMessages.required_message.title') }}"
                    },
                    start_end_time: {
                        required: "{{ config('globalMessages.required_message.start_end_time') }}"
                    },
                    url: {
                      complete_url: "{{ config('globalMessages.required_message.c_url') }}"
                    },
                    seats: {
                      complete_url: "{{ config('globalMessages.required_message.seats') }}"
                    }
                },

        });

        $('.open-edit-modal').on('click',function(){
            let event_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "{{ url(   'api/'.appName(Request())  .  '/get-event-details')  }}/" + event_id,
                success:function(data){
                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;
    
                    $('input[name="start_end_time"]').daterangepicker({
                        timePicker: true,
                        startDate: moment(print_data.start_date).format("MM/DD/YYYY hh:mma"),
                        endDate: moment(print_data.end_date).format("MM/DD/YYYY hh:mma"),
                        minDate: moment(print_data.start_date).format("MM/DD/YYYY hh:mma"),
                        locale: {
                            format: 'MM/DD/YYYY hh:mma'
                        }
                        });
                        $('input[name="start_end_time"]').on('hide.daterangepicker', function(ev, picker) {
                        if (picker.startDate.format('MM/DD/YYYY') == picker.endDate.format('MM/DD/YYYY')) {
                            var from = picker.startDate.format('hh:mma');
                            var to = picker.endDate.format('hh:mma');
                            if (moment(from, 'hh:mm a') > moment(to, 'hh:mm a')) {
                            $('input[name="start_end_time"]').val('');
                            }
                        }
                        if (picker.startDate.format('MM/DD/YYYY hh:mma') == picker.endDate.format('MM/DD/YYYY hh:mma')) {
                            $('input[name="start_end_time"]').closest("div").addClass('has-error');
                            $('input[name="start_end_time"]').val('');
                        } else {
                            $('input[name="start_end_time"]').closest("div").removeClass('has-error');
                        }
                    });

                    $('.category_id1').val(print_data.category_id);
                    $('.title1').val(print_data.title);
                    $('.description1').val(print_data.description);
                    $('.url1').val(print_data.url);
                    $('.seats1').val(print_data.seats);
                    $('.phone1').val(print_data.phone);
                    $('.event_status1').val(print_data.event_status);
                    $('.order_num1').val(print_data.order_num);
                    $('#event_id').val(print_data.id);
                    $('#editModal').modal('show');
                },
                error:function(err){
                    console.log(err)
                }
            });

        });



        $('#editform').validate({
            rules: {
                title: {
                    required: true,
                },
                start_end_time: {
                    required: true
                },                phone: {
                    maxlength: 14,
                    numericdashe: true
                },
                url: {
                    complete_url: true
                },
                     seats: {
                        complete_url: true
                    }
            },            messages: {
                title: {
                    required: "This field is required"
                },
                start_end_time: {
                    required: "This field is required"
                },
                 url: {
                      complete_url: "{{ config('globalMessages.required_message.c_url') }}"
                    },
                    seats: {
                      complete_url: "{{ config('globalMessages.required_message.seats') }}"
                    }
            },
        });

        jQuery.validator.addMethod("complete_url", function(val, elem) {
            if (val.length == 0) {
            return true;
            }
            if (!/^(https?|ftp):\/\//i.test(val)) {
            val = 'http://' + val;
            $(elem).val(val);
            }
            return /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(val);
        });

        jQuery.validator.addMethod("numericdashe", function(value, element) {
            return this.optional(element) ||
            value.length >= 4 && /^[0-9\-\+]+$/i.test(value);
        });

         // reset edit form and validation errors and message
         $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#editModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        // reset add form and validation errors and message
        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "{{ config('globalMessages.delete_event_warning_title')  }}",
               text: "{{ config('globalMessages.delete_event_warning_text')  }}",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let event_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "{{ url('api/'.appName(Request()) . '/delete-event')  }}",
                        data:{
                            "_token": "{{ csrf_token() }}",
                            "event_id": event_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });



        $('input[name="start_end_time"]').daterangepicker({
      timePicker: true,
      startDate: moment().startOf('hour'),
      endDate: moment().startOf('hour'),
      minDate: new Date(),
      locale: {
        format: 'MM/DD/YYYY hh:mma',
      },
    });
    $('input[name="start_end_time"]').on('hide.daterangepicker', function(ev, picker) {
      if (picker.startDate.format('MM/DD/YYYY') == picker.endDate.format('MM/DD/YYYY')) {
        var from = picker.startDate.format('hh:mma');
        var to = picker.endDate.format('hh:mma');
        if (moment(from, 'hh:mm a') > moment(to, 'hh:mm a')) {
          $('input[name="start_end_time"]').val('');
        }
      }
      if (picker.startDate.format('MM/DD/YYYY hh:mma') == picker.endDate.format('MM/DD/YYYY hh:mma')) {
        $('input[name="start_end_time"]').closest("div").addClass('has-error');
        $('input[name="start_end_time"]').val('');
      } else {
        $('input[name="start_end_time"]').closest("div").removeClass('has-error');
      }
    });
    $('input[name="start_end_time"]').val('');
    </script>
@endsection
