
<?php $__env->startSection('title', $fields_name['header_title']); ?>
<?php $__env->startSection('content'); ?>

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right open-add-modal" data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title"> <?php echo e($fields_name['table_header_title']); ?> </h4>
            <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>

            <?php if($message = session()->get('error')): ?>
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>
            <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>Error!</strong> There were some problems with your input.
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="resource-table">
                <thead class="text-primary">
                  <th>#</th>
                  <th>Images</th>
                  <th>Title</th>
                  
                  <th>Address</th>
                  <th>Resource Status</th>
                  <th>Order</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $resource; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td>
                        <?php if($row->image_path !=null && file_exists($row->image_path)): ?>
                            <img src="<?php echo e(url($row->image_path)); ?>" height="75" />
                        <?php else: ?>
                            <span>-</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($row->title); ?></td>
                    
                    <td><?php echo e($row->address); ?></td>
                    <td><?php echo e(ucfirst($row->resource_status)); ?></td>
                    <td><?php echo e($row->order_num); ?></td>
                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item open-edit-modal"  data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Edit</a>
                            <a class="dropdown-item open-edit-delete" data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Delete</a>
                      </div>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

<!-- Add modal -->
<?php echo $__env->make('resource.modal.add-resource-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- edit Modal -->
<?php echo $__env->make('resource.modal.edit-resource-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script-section'); ?>
    <script>
         $(document).ready(function() {
            $('#resource-table').DataTable();

            $('.open-add-modal').on('click',function(){
                $('#AddModal').find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
            }) ;

        });


        $('#addform').validate({
            rules: {
                image: {
                    required: true,
                },
                title: {
                    required: true,
                },
            },
            messages: {
                image: {
                    required: "<?php echo e(config('globalMessages.required_message.image')); ?>",
                },
                title: {
                    required: "<?php echo e(config('globalMessages.required_message.title')); ?>"
                },
            },
        });

        $('.open-edit-modal').on('click',function(){
            let resource_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "<?php echo e(url( 'api/'.appName(Request())  .'/get-resource-details')); ?>/" + resource_id,
                success:function(data){
                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;

                    $('.title1').val(print_data.title);
                    // $('#e_category_id').val(print_data.category_id);
                    $('.description1').val(print_data.description);
                    $('.latitude1').val(print_data.latitude);
                    $('.longitude1').val(print_data.longitude);
                    $('.phone1').val(print_data.phone);
                    $('.url1').val(print_data.url);
                    $('.address1').val(print_data.address);
                    $('.resource_status1').val(print_data.resource_status);
                    $('.order_num1').val(print_data.order_num);
                    $('#resource_id').val(print_data.id);
                    $('#editModal').modal('show');
                },
                error:function(err){
                    console.log(err)
                }
            });

        });

        $('#editform').validate({
            rules: {
                title: {
                    required: true,
                },
            },
            messages: {
                title: {
                    required: "<?php echo e(config('globalMessages.required_message.title')); ?>"
                },
            },
        });

        $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#editModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "<?php echo e(config('globalMessages.delete_resource_warning_title')); ?>",
               text: "<?php echo e(config('globalMessages.delete_resource_warning_text')); ?>",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let resource_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "<?php echo e(url('api/'.appName(Request()) . '/delete-resource')); ?>",
                        data:{
                            "_token": "<?php echo e(csrf_token()); ?>",
                            "resource_id": resource_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yaujalmy/public_html/coc/resources/views/resource/index.blade.php ENDPATH**/ ?>