<?php $__env->startSection('title', 'Ads'); ?>
<?php $__env->startSection('content'); ?>
<div class="content">
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#AddModal"> ADD </button>
          <h4 class="card-title"> Ads List</h4>
          <?php if($message = Session::get('success')): ?>
          <div class="alert alert-success alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong><?php echo e($message); ?></strong>
          </div>
          <?php endif; ?>

          <?php if(count($errors) > 0): ?>
          <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.
            <ul>
              <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><?php echo e($error); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
          <?php endif; ?>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table" id="example">
              <thead class=" text-primary">
                <th>#</th>
                <th>Images</th>
                <th>URL</th>
                <th>Expiration</th>
                <th>Total Clicks</th>
                <th>Order</th>
                <th>Ads Status</th>
                <th class="text-center">Action</th>
              </thead>
              <tbody>
                <?php
                ?>
                <?php $__currentLoopData = $add_ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($loop->iteration); ?></td>
                  <td><?php echo e($row->image_path); ?></td>
                  <td><?php echo e($row->url); ?></td>
                  <td><?php echo e(\Carbon\Carbon::parse($row->expiration)->format('d-M-Y')); ?></td>
                  <td><?php echo e($row->total_clicks); ?></td>
                  <td><?php echo e($row->order_num); ?></td>
                  <td><?php echo e($row->ads_status); ?></td>
                  <td class="text-center">
                    <div class="dropdown">
                      <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        Action
                      </button>
                      <div class="dropdown-menu">
                        <a class="dropdown-item edit" data-id="<?php echo e($row->id); ?>" data-name="ads">Edit</a>
                        <a class="dropdown-item delete" data-id="<?php echo e($row->id); ?>" data-name="ads" href="#">Delete</a>
                      </div>
                    </div>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- add Modal -->
<div class="modal fade" id="AddModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <form id="addform" method="post" action="<?php echo e(url('/app/' .appName(Request()). '/add_ads')); ?>" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Add Ads</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true close-btn">×</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label for="addInput1">Select Image * <span style="color:red;" class="err_msg"></span></label>
              <input type="file" accept="image/*" class="form-control-file ads_image" name="image" id="addInput1" style="opacity: unset; position: unset">

            </div>
            <div class="form-group">
              <label for="addInput2">Url *</label>
              <input type="url" class="form-control" name="url" id="addInput2" placeholder="Enter Url" >
            </div>
            <div class="form-group">
            <label for="addInput2">Ads Status</label>
            <select name="ads_status" class="form-control">
              <option value="active">Active</option>
              <option value="inactive">Inactive</option>
            </select>
            </div>

            <div class="form-group">
              <label for="txtDate">Expiration * </label>
              <input type="date" class="form-control date" name="expiration" id="txtDate" placeholder="" >
            </div>
            <div class="form-group">
              <label for="addInput5">Order</label>
              <input type="text" class="form-control" name="order" maxlength="4" id="addInput5" placeholder="Enter Order" >
            </div>

          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
            <button type="submit" id="submit" class="btn btn-primary close-modal ">Submit</button>
          </div>
        </form>
      </div>
    </div>
</div>

  <!-- edit Modal -->
<div class="modal fade" id="editmodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <form id="editform" method="post" action="<?php echo e(url('/app/' .appName(Request()). '/update_ads')); ?>" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Edit Ads</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true close-btn">×</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label for="addInput1">Select Image <span style="color:red;" class="err_msg"></span></label>
              <input type="file" accept="image/*" class="form-control-file ads_image" name="image" id="addInput1" style="opacity: unset; position: unset">
            </div>
            <div class="form-group">
              <label for="addInput2">Url *</label>
              <input type="url" class="form-control" name="url" id="url" placeholder="Enter Url" >
            </div>
            <div class="form-group">
            <label for="addInput2">Ads Status</label>
            <select name="ads_status" id="ads_status" class="form-control">
              <option value="active">Active</option>
              <option value="inactive">Inactive</option>
            </select>
            </div>
            <div class="form-group">
              <label for="addInput4">Expiration *</label>
              <input type="date" class="form-control date" name="expiration" id="expiration" placeholder="" >
            </div>
            <div class="form-group">
              <label for="addInput5">Order</label>
              <input type="text" class="form-control" name="order"  maxlength="4"  id="order" placeholder="Enter Order" >
            </div>
          </div>
          <input type="hidden" name="ads_id" id="ads_id">
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary close-modal ">Save changes</button>
          </div>
        </form>
      </div>
    </div>
</div>

<script>
    $(document).ready(function() {

      // ---------------------------------------------- Fill Edit data  -------------------------------------------------------

      $(document).on('click', '.edit', function() {
        $("#editform").find('.has-error').removeClass("has-error");
        $("#editform").find('.has-success').removeClass("has-success");
        $("#editform").find('.err_msg').text("");
        $('#editform').find('.form-control-feedback').remove();
        var id = $(this).data('id');
        var name = $(this).data('name');
        $.ajax({
          type: 'POST',
          url: "<?php echo e(url('/app/' .appName(Request()). '/getads')); ?>",
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: {
            'id': id,
            'name': name
          },
          success: function(data) {
            if (data) {
              $('#url').val(data.url);
              $('#expiration').val(dateConverter(data.expiration));
              $('#order').val(data.order_num);
              $('#ads_status').val(data.ads_status);
              $('#ads_id').val(data.id);
              $('#editmodal').modal('show');
            }
          }
        });
      });
      $('#addform').validate({
        rules: {
          image: {
            required: true,
          },
          url: {
            required: true,
            complete_url: true
          },
          expiration: {
            required: true,
          }
        },
        messages: {
          image: {
            required: "This field is required",
          },
          url: {
            required: "This field is required"
          },
          expiration: {
            required: "This field is required"
          }
        },
        errorPlacement: function(error, element) {
          element.closest("div").addClass('has-error');
        },
        success: function(error, element) {
          $(element).closest("div").removeClass('has-error');
        }
      });
      $('#editform').validate({
        rules: {
          url: {
            required: true,
            complete_url: true
          },
          expiration: {
            required: true,
          }

        },
        messages: {
          url: {
            required: "This field is required"
          },
          expiration: {
            required: "This field is required"
          }

        },
        errorPlacement: function(error, element) {
          element.closest("div").addClass('has-error');
        },
        success: function(error, element) {
          $(element).closest("div").removeClass('has-error');
        }
      });
      jQuery.validator.addMethod("complete_url", function(val, elem) {
        if (val.length == 0) {
          return true;
        }
        if (!/^(https?|ftp):\/\//i.test(val)) {
          val = 'http://' + val;
          $(elem).val(val);
        }
        return /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(val);
      });
    });
    $(function(){
      var dtToday = new Date();

      var month = dtToday.getMonth() + 1;
      var day = dtToday.getDate();
      var year = dtToday.getFullYear();
      if(month < 10)
          month = '0' + month.toString();
      if(day < 10)
          day = '0' + day.toString();

      var maxDate = year + '-' + month + '-' + day;
      $('#txtDate').attr('min', maxDate);
      $('#expiration').attr('min', maxDate);
    });

    $(document).on('click', '.delete', function() {
        if (confirm("Are you sure You want to delete it?")) {
          var id = $(this).data('id');
          var name = $(this).data('name');
          $.ajax({
            type: 'POST',
            url: "<?php echo e(url('/app/' .appName(Request()). '/deleteads')); ?>",
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
              'id': id,
              'name': name
            },
            success: function(data) {
              if (data) {
                alert("Delete successfully.");
                window.location.reload();
              } else {
                alert("Somthing went wrong.");
              }
            }
          });
        }
    });
</script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\chamber-ddd\resources\views/ads/index.blade.php ENDPATH**/ ?>