<?php $__env->startSection('title', 'Send Notification'); ?>
<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h4 class="card-title"> Send Notification</h4>
            <?php if($message = session()->get('success')): ?>
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>

            <?php if($message = session()->get('error')): ?>
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>
            <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>Error!</strong> There were some problems with your input.
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
          </div>
          <div class="card-body">
            <div class="content">
                <form id="addform" method="post" action="<?php echo e(url(baseRedirectUrl(Request()). '/send-notification' )); ?>" >
                  <?php echo csrf_field(); ?>
                    
                    <?php if(count(getFormFields(Request(),'notification')) > 0): ?>
                    <?php $__currentLoopData = getFormFields(Request(),'notification'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!in_array($field_item['input_type'],["textarea","select_user"])): ?>
                            <div>
                                <div class="form-group">
                                    <div class="form-group">
                                        <label for="<?php echo e($field_item['id']); ?>"><?php echo e($field_item['label']); ?></label>
                                        <input type="<?php echo e($field_item['input_type']); ?>" accept="image/*" class="<?php echo e($field_item['class']); ?>" name="<?php echo e($field_item['name']); ?>" id="<?php echo e($field_item['id']); ?>" style="opacity: unset; position: unset" placeholder="<?php echo e($field_item['placeholder']); ?>" value="<?php echo e($field_item['value']); ?>">
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if($field_item['input_type'] == "textarea"): ?>
                            <div class="form-group">
                                <label for="<?php echo e($field_item['id']); ?>"><?php echo e($field_item['label']); ?></label>
                                <textarea name="<?php echo e($field_item['name']); ?>" id="<?php echo e($field_item['id']); ?>" class="<?php echo e($field_item['class']); ?>"></textarea>
                            </div>
                        <?php endif; ?>

                        <?php if($field_item['input_type'] == 'select_user' ): ?>
                                <div class="form-group">
                                    <label for="<?php echo e($field_item['id']); ?>"><?php echo e($field_item['label']); ?></label>
                                    <select name="<?php echo e($field_item['name']); ?>" id="<?php echo e($field_item['id']); ?>" class="<?php echo e($field_item['class']); ?>">
                                    <?php $__currentLoopData = $field_item['option']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item['value']); ?>"><?php echo e($item['text']); ?></option>  
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                        <?php endif; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    <div class="form-group">
                        <button type="submit" id="submit" class="btn btn-primary "><?php echo e(config('globalLabel.send_notification_send_btn')); ?></button>
                        <a href="javascript:window.history.back()">
                            <button type="button" class="btn btn-secondary close-btn"><?php echo e(config('globalLabel.send_notification_close_btn')); ?></button>
                        </a>
                    </div>
                </form>
              </div>
          </div>
        </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script-section'); ?>
    <script>
        $('#addform').validate({
            rules: {

                title: {
                    required: true,
                },
                description: {
                    required: true,
                },
            },
            messages: {
                title: {
                    required: "<?php echo e(config('globalMessages.required_message.title')); ?>"
                },
                description: {
                    required: "<?php echo e(config('globalMessages.required_message.description')); ?>",
                },
            },
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yaujalmy/public_html/coc/resources/views/notification/send-notification.blade.php ENDPATH**/ ?>