<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MapDirectory;
use App\Models\Category;
use DB;
use App\Http\Traits\MapDirectoryTraits;


class MapDirectoryController extends Controller
{
    use MapDirectoryTraits;


    public function getMapDirectoryList(Request $request,$user_id)
    {
        $MapDirectory =  $this->getAllMapDirectory($user_id);
            foreach ($MapDirectory as $new_mp) {
                $categoryName = Category::where('id', $new_mp->category_id)->first();
                if ($categoryName) {
                    $new_mp->category_name = $categoryName->name;
                } else {
                    $new_mp->category_name = "None";
                }
            }
            $category = Category::orderBy('order_num', 'DESC')->get();

            $getDynamicFields = getIndexFields(Request(),'map_directory');

        return view('map-directory.index')->with(['MapDirectory' => $MapDirectory,'category'=>$category,'fields_name'=>$getDynamicFields]);

    }

    public function addMapDirectory(Request $request)
    {

        $request->validate([
            'image' => "required|image|mimes:jpeg,png,jpg,gif,svg",
            'title' => "required",
        ]);

        extract($request->all());

        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'map_directory');
        } else {
            $image_path = '';
        }

        $request->merge(["image_path"=>$image_path]);

        $addDirectory= $this->createMapDirectory($request);
        if($addDirectory){
            return back()->with(["success" => config('globalMessages.map_directory_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.map_directory_create_error')]);
        }
    }

    public function editMapDirectory(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'title' => "required",
        ]);

        extract($request->all());

        $checkMapDirectory = $this->updateMapDirectory($request);
        if($checkMapDirectory){
            return back()->with(["success" => config('globalMessages.map_directory_update_success')]);
        }else{
            return back()->with(["error" => config('globalMessages.map_directory_update_error') ]);
        }
    }

}
