<?php
namespace App\Http\Traits;
use App\Models\Event;
use DB;

trait EventTraits {

    public function getAllEvent()
    {
        return Event::where('end_date', '>=', date('Y-m-d'))->orderBy('id', 'DESC')->get();
    }

    public function selectAllEvent($category_id)
    {
        $today = date('Y-m-d');

        if(isset($category_id)){
            $get_event= DB::table('events as e')
            ->select('e.*','ec.name as category_name','ec.image_path as cat_image',
            DB::raw("CONCAT('".env('APP_URL')."/',e.image_path) as image_path"),
            DB::raw("CONCAT('".env('APP_URL')."/',ec.image_path) as cat_image"))
            ->leftjoin('events_category as ec','ec.id','=','e.category_id')
            ->orWhere(function($query) use($category_id){
                if($category_id != ""){
                    $query->where('e.category_id',$category_id);
                }
            })
            ->where('end_date','>=',"$today")
            ->where('event_status','active')
            ->where('e.deleted_at','=',null)
            ->orderBy('start_date','asc')
            ->get();

        }else{
            $get_event= Event::select('*',DB::raw("CONCAT('".env('APP_URL')."/',image_path) as image_path"))
                ->where('end_date','>=',"$today")
                ->where('event_status','active')
                ->orderBy('start_date','asc')
                ->get();
        }
        
        return $get_event;
    }

    public function getEventDetail($event_id)
    {
        return Event::find($event_id);
    }

    public function createEvent($request)
    {
        return Event::create($request->all());
    }

    public function getImagePath($event_id)
    {
        $image_path = "";

        $event = Event::find($event_id);
        if($event){
            $image_path = $event->image_path;
        }

        return $image_path;
    }

    public function updateEvents($event_id,$arr)
    {
        return Event::where('id',$event_id)->update($arr);
    }

    public function eventDelete($request)
    {
        $event_id = $request->get('event_id');
        return Event::where('id',$event_id)->delete();
    }

}
