<?php
namespace App\Http\Traits;
use App\Models\Category;
use DB;

trait MapCategoryTraits {

    public function getAllMapCategory()
    {
        return Category::all();
    }

    public function SelectAllMapCatory()
    {
        return Category::select('*',DB::raw("CONCAT('".env('APP_URL')."/',image_path) as image_path"))
        ->where('category_status','active')
        ->get();
    }

    public function getMapCategoryDetail($category_id)
    {
        return Category::find($category_id);
    }

    public function craeteCategory($request)
    {
        return Category::create($request->all());
    }

    public function getImagePath($category_id)
    {
        $image_path = "";
        $category = Category::find($category_id);
        if($category){
            $image_path = $category->image_path;
        }

        return $image_path;
    }

    public function updateCategory($request)
    {
        $category_id = $request->get('category_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['category_id']);

        $currentImagePath = $this->getImagePath($category_id);
        $image_path = "";
        if ($request->hasFile('image')) {
            $image_path = storeImage($request,$request->image,'category');
        } else {
            $image_path = '';
        }

        if($image_path != ""){
            $arr = array_merge($arr,['image_path' => $image_path]);
        }
        unset($arr['image']);

        $category= Category::where('id',$category_id)->update($arr);
        if($image_path != "" && $currentImagePath != ""){

            if(file_exists($currentImagePath)){
                unlink($currentImagePath);
            }
        }

        return $category;
    }

    public function categoryDelete($request)
    {
        $category_id = $request->get('category_id');
        return Category::where('id',$category_id)->delete();
    }
}
