<?php
namespace App\Http\Traits;
use App\Models\NewsBlogs;
use DB;

trait NewsBlogsTraits {

    public function getNewsBlogs(Type $var = null)
    {
        return NewsBlogs::all();
    }

    public function SelectAllNewsBlogs()
    {
        return NewsBlogs::select('*',DB::raw("CONCAT('".env('APP_URL')."/',image_path) as image_path"))
        ->where('blogs_status','active')
        ->get();
    }

    public function getNewsBlogsDetail($news_blogs_id)
    {
        return NewsBlogs::find($news_blogs_id);
    }

    public function createNewsBlogs($request)
    {
        return NewsBlogs::create($request->all());
    }

    public function updateNewsBlogs($request)
    {
        $news_blogs_id = $request->get('news_blogs_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['news_blogs_id']);

        $currentImagePath = $this->getImagePath($news_blogs_id);
        $image_path = "";
        if ($request->hasFile('image')) {
            $image_path = storeImage($request,$request->image,'news_blogs');
        } else {
            $image_path = '';
        }

        if($image_path != ""){
            $arr = array_merge($arr,['image_path' => $image_path]);
        }
        unset($arr['image']);

        $news_blogs= NewsBlogs::where('id',$news_blogs_id)->update($arr);
            if($image_path != "" && $currentImagePath != ""){
                if(file_exists($currentImagePath)){
                    unlink($currentImagePath);
                }
            }
        return $news_blogs;
    }

    public function getImagePath($news_blogs_id)
    {
        $image_path = "" ;
        $news_blogs = NewsBlogs::find($news_blogs_id);
        if($news_blogs){
            $image_path = $news_blogs->image_path;
        }

        return $image_path;
    }

    public function newsBlogsDelete($request)
    {
        $news_blogs_id = $request->get('news_blogs_id');
        return NewsBlogs::where('id',$news_blogs_id)->delete();
    }
}
