<?php

use Intervention\Image\Facades\Image;
use Laravel\Passport\Client as OClient;


function appName($request){
    return $request->segment('2');
}

function baseRedirectUrl($request): String
{
    return 'app/'.appName($request);
}

function getSideBar($request){
    $sidebar = [];

    $config_file = public_path('app-config/' . appName($request) . '/config.json');

    // check config file is exist or not
    if(!file_exists($config_file)){
        return $sidebar;
    }

    $decode_config_file = json_decode(file_get_contents($config_file),true);
    if(isset($decode_config_file['sidebar']) && count($decode_config_file['sidebar']) > 0){
        $sidebar = $decode_config_file['sidebar'];
    }

    return $sidebar;
}

function getFirebaseServerKey($request){
    $firebase_server_key = "";

    $config_file = public_path('app-config/' . appName($request) . '/config.json');

    // check config file is exist or not
    if(!file_exists($config_file)){
        return $firebase_server_key;
    }

    $decode_config_file = json_decode(file_get_contents($config_file),true);
    if(isset($decode_config_file['firebase_server_key']) && $decode_config_file['firebase_server_key'] != ''){
        return $decode_config_file['firebase_server_key'];
    }
    return $firebase_server_key;
}

function storeImage($request,$image,$folderName): String {
    $imageName = time() . '.' . $image->extension();

    $dir = public_path('/app-storage/' . appName($request) . '/images/'.$folderName);
    if(!file_exists($dir)){
        mkdir($dir,0777,true);
    }

    $imageFullPath = $dir .'/'. $imageName;

    $store_image = Image::make($image);
    $store_image->save($imageFullPath,60);

    return "app-storage/" . appName($request) . '/images/'.$folderName . "/" . $imageName;
}


function getTokenAndRefreshToken($email,$password,$request)
    {
        // get active Client
        $oClient = OClient::where('password_client',1)->first();

        // send request for refresh and access token

		$http = new \GuzzleHttp\Client();
        try{

            $response = $http->post("http://localhost:5000/api/" . appName($request) . "/oauth/token",[
                'form_params'   =>  [
                    'grant_type' => 'password',
                    'client_id' => $oClient->id,
                    'client_secret' => $oClient->secret,
                    'username' => $email,
                    'password' => $password,
                    'name'  => appName($request),
                    'scope' => ''
                ]
            ]);

        }catch(Exception $e){
            $res['status'] = 'error';
            $res['message'] = $e->getMessage();
            return $res;
        }
        $result = json_decode((string) $response->getBody(), true);
        return $result;
}

function getFormFields($request,$form_name = ""){

    $fields = [];

    $field_file = public_path('app-config/' . appName($request) . '/formFields.json');

    if(!file_exists($field_file)){
        return $fields;
    }

    $decode_fields_file = json_decode(file_get_contents($field_file),true);
    if(isset($decode_fields_file[$form_name]) && count($decode_fields_file[$form_name]) > 0){
        return $decode_fields_file[$form_name];
    }

}

function getIndexFields($request,$index_name = ""){
    $fields = [];

    $field_file = public_path('app-config/' . appName($request) . '/indexFields.json');

    if(!file_exists($field_file)){
        return $fields;
    }

    $decode_fields_file = json_decode(file_get_contents($field_file),true);
    if(isset($decode_fields_file[$index_name]) && count($decode_fields_file[$index_name]) > 0){
        return $decode_fields_file[$index_name];
    }
}
