<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class NewsBlogs extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'news_blogs';

    protected $fillable = [
        'id',
        'image_path',
        'title',
        'description',
        'url',
        'blogs_status',
        'order_num',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'id' => 'integer',
        'image_path' => 'string',
        'title' => 'string',
        'description' => 'string',
        'url' => 'string',
        'blogs_status' => 'string',
        'order_num' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

}
