<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AdsController;
use App\Http\Controllers\Api\AccountController;
use App\Http\Controllers\Api\DirectoryCategoryController;
use App\Http\Controllers\Api\DirectoryController;
use App\Http\Controllers\Api\EventController;
use App\Http\Controllers\Api\EventCategoryController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Api\MapCategoryController;
use App\Http\Controllers\Api\MapDirectoryController;
use App\Http\Controllers\Api\ResourceCategoryController;
use App\Http\Controllers\Api\ResourceController;
use App\Http\Controllers\Api\NewsBlogsController;
use App\Http\Controllers\Api\AppCongifController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\Auth\AuthController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => '{app_name}','middleware' => 'DatabaseConnectionChooser'],function(){


    Route::controller(AccountController::class)->group(function(){
        Route::post('signup','signup');
        Route::post('forgotpass','forgotPassword');
        Route::post('joinchamber','joinChamber');
        Route::post('devicetoken','devicetoken');
    });

    Route::controller(LoginController::class)->group(function(){
        Route::post('login','login');
    });

    Route::controller(AdsController::class)->group(function(){
        Route::post('adsclick',  'adsclick');
        Route::get('get-ads',"adsList");
    });

    Route::controller(DirectoryCategoryController::class)->group(function(){
        Route::get('directory-category',"getDirectoryCategoryList");
    });
    Route::controller(DirectoryController::class)->group(function(){
        Route::get('dirbycat',"getDirectoryList");

    });
    Route::controller(EventController::class)->group(function(){
        Route::get('events',"getEventList");

    });
    Route::controller(EventCategoryController::class)->group(function(){
        Route::get('events-category',"getEventCategoryList");

    });
    Route::controller(ResourceCategoryController::class)->group(function(){
        Route::get('resource-category',"getResourceCategoryList");
    });
    Route::controller(ResourceController::class)->group(function(){
        Route::get('resbycat',"getResourceList");

    });
    Route::controller(MapCategoryController::class)->group(function(){
        Route::get('category',"getMapCategoryList");

    });
    Route::controller(MapDirectoryController::class)->group(function(){
        Route::get('mapbycat',"getMapDirectoryList");

    });
    Route::controller(NewsBlogsController::class)->group(function(){
        Route::get('news-blogs',"getNewsBlogsList");

    });
    Route::controller(AppCongifController::class)->group(function(){
        Route::get('checkLogin','loginCheck');
    });

        // Route::post('oauth/token',[AuthController::class,"auth"]);

    Route::post('send-notification',[NotificationController::class,'apisendNotification']);

    Route::get('get-account-details/{user_id}',[AccountController::class,'getAccountDetails']);
    Route::get('get-ads-details/{ads_id}',[AdsController::class,'getAdsDetails']);
    Route::get('get-directory-category-details/{category_id}',[DirectoryCategoryController::class, 'getDirCateDetails']);
    Route::get('get-directory-details/{directory_id}',[DirectoryController::class,'getDirectoryDetails']);
    Route::get('get-event-details/{event_id}',[EventController::class ,'getEventDetails']);
    Route::get('get-category-details/{category_id}',[MapCategoryController::class,'getMapCategoryDetails']);
    Route::get('get-map-directory-details/{map_directory_id}',[MapDirectoryController::class,'getMapDirectoryDetails']);
    Route::get('get-resource-details/{resource_id}',[ResourceController::class ,'getResourceDetails']);
    Route::get('get-resource-category-details/{res_cat_id}',[ResourceCategoryController::class ,'getResourceCategoryDetails']);
    Route::get('get-news-blogs-details/{news_blogs_id}',[NewsBlogsController::class ,'getNewsBlogsDetails']);
    Route::get('get-event-category-details/{category_id}',[EventCategoryController::class, 'getEventCategoryDetails']);


    Route::post('/delete-account',[AccountController::class,'deleteAccount'])->name('delete-account');
    Route::post('/delete-event',[EventController::class ,'deleteEvent'])->name('delete-event');
    Route::post('/delete-ads',[AdsController::class,'deleteAds']);
    Route::post('/delete-directory-category',[DirectoryCategoryController::class,'deleteDirectoryCategory']);
    Route::post('/delete-directory',[DirectoryController::class,'deleteDirectory']);
    Route::post('/delete-category',[MapCategoryController::class,'deleteMapCategory']);
    Route::post('/delete-map-directory',[MapDirectoryController::class,'deleteMapDirectory']);
    Route::post('/delete-resource-category',[ResourceCategoryController::class,'deleteResourceCategory']);
    Route::post('/delete-resource',[ResourceController::class,'deleteResource']);
    Route::post('/delete-news-blogs',[NewsBlogsController::class,'deleteNewsBlogs']);
    Route::post('/delete-event-category',[EventCategoryController::class,'deleteEventCategory']);


});
