<?php $__env->startSection('title', 'Ads'); ?>
<?php $__env->startSection('content'); ?>
<div class="content">
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#add-ads-modal"> ADD </button>
          <h4 class="card-title"> Ads List</h4>
          <?php if($message = Session::get('success')): ?>
          <div class="alert alert-success alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong><?php echo e($message); ?></strong>
          </div>
          <?php endif; ?>

          <?php if(count($errors) > 0): ?>
          <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.
            <ul>
              <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><?php echo e($error); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
          <?php endif; ?>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table" id="ads-table">
              <thead class="text-primary">
                <th>#</th>
                <th>Images</th>
                <th>URL</th>
                <th>Expiration</th>
                <th>Total Clicks</th>
                <th>Order</th>
                <th>Ads Status</th>
                <th class="text-center">Action</th>
              </thead>
              <tbody>
                <?php $__currentLoopData = $add_ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($loop->iteration); ?></td>
                  <td><img src="<?php echo e(asset($row->image_path)); ?>" height="75"/></td>
                  <td>
                      <?php if($row->url != ""): ?>
                          <a href="<?php echo e($row->url); ?>" target="_blank" > <?php echo e($row->url); ?> </a>
                      <?php else: ?>
                          <span> - </span>
                      <?php endif; ?>
                  </td>
                  <td><?php echo e(date('d-m-Y',strtotime($row->expiration))); ?></td>
                  <td><?php echo e($row->ads_click_count); ?></td>
                  <td><?php echo e($row->order_num); ?></td>
                  <td><?php echo e(ucfirst($row->ads_status)); ?></td>
                  <td class="text-center">
                    <div class="dropdown">
                      <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        Action
                      </button>
                      <div class="dropdown-menu">
                        <a class="dropdown-item edit-ads-modal" data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Edit</a>
                        <a class="dropdown-item delete-ads" data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Delete</a>
                      </div>
                    </div>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- add Modal -->
<?php echo $__env->make('ads.modal.add-ads-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- edit Modal -->
<?php echo $__env->make('ads.modal.edit-ads-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script-section'); ?>
    <script>

        $(document).ready(function() {
            $('#ads-table').DataTable();

            $('#expiration').daterangepicker({
                singleDatePicker: true,
                minDate: new Date()
            });

            $('#e_expiration').daterangepicker({
                singleDatePicker: true,
                minDate: new Date()
            });

            $('#add-ads-form').validate({
                rules: {
                    image: {
                        required: true,
                    },
                    url: {
                        required: true,
                    },
                    expiration: {
                        required: true,
                    }
                },
                messages: {
                    image: {
                        required: "<?php echo e(config('globalMessages.required_message.image')); ?>"
                    },
                    url: {
                        required: "<?php echo e(config('globalMessages.required_message.url')); ?>"
                    },
                    expiration: {
                        required: "<?php echo e(config('globalMessages.required_message.expiration')); ?>"
                    }
                }
            });

            $('.edit-ads-modal').on('click',function(){
                let ads_id = $(this).data('id');
                $.ajax({
                    type:"GET",
                    url: "<?php echo e(url( baseRedirectUrl(Request()) . '/get-ads-details' )); ?>/" + ads_id,
                    success:function(data){
                        if (data.status == 'success') {

                            $('#e_url').val(data.data.url);
                            $('#e_ads_status').val(data.data.ads_status);
                            $('#e_expiration').val(moment(data.data.expiration).format('MM-DD-Y'));
                            $('#e_order').val(data.data.order_num);
                            $('#e_ads_id').val(data.data.id);

                            $('#edit-ads-modal-id').modal('show');
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: "Error!",
                                text: data.message
                            });
                        }
                    },
                    error:function(err){
                        console.log(err);
                    }
                });

            });

            $('#edit-ads-form').validate({
                rules:{
                    url: {
                        required: true,
                    },
                    expiration: {
                        required: true,
                    }
                },
                messages: {
                    url: {
                        required: "<?php echo e(config('globalMessages.required_message.url')); ?>"
                    },
                    expiration: {
                        required: "<?php echo e(config('globalMessages.required_message.expiration')); ?>"
                    }
                }
            });

            // reset edit form and validation errors and message
            $('#edit-ads-modal-id').on('hidden.bs.modal', function () {
                $(this).find('form').trigger('reset');
                let $alerts = $('#edit-ads-form');
                $alerts.validate().resetForm();
                $alerts.find('.error').removeClass('error');
            });

            // reset add form and validation errors and message
            $('#add-ads-modal').on('hidden.bs.modal', function () {
                $(this).find('form').trigger('reset');
                let $alerts = $('#add-ads-form');
                $alerts.validate().resetForm();
                $alerts.find('.error').removeClass('error');
            });

            $('.delete-ads').on('click',function(){
                let ad_id = $(this).data('id');

                Swal.fire({
                    icon:"warning",
                    title:"Are you sure?",
                    text:"Are you sure want to delete this ad?",
                    showConfirmButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    cancelButtonText: "No"
                }).then((ok) => {
                        if(ok['isConfirmed']){
                            $.ajax({
                                type:"POST",
                                url: "<?php echo e(url(baseRedirectUrl(Request()) . '/delete-ads')); ?>",
                                data:{
                                    "_token": "<?php echo e(csrf_token()); ?>",
                                    "ads_id": ad_id
                                },
                                success:function(data){
                                    if(data.status == 'success'){
                                        Swal.fire({
                                            icon:"success",
                                            title:"Success!",
                                            text: data.message
                                        }).then((ok) => {
                                            if(ok){
                                                window.location.reload();
                                            }
                                        });
                                    }else{
                                        Swal.fire({
                                           icon:"error",
                                            title:"Error!",
                                            text: data.message
                                        });
                                    }
                                },
                                error:function(err){
                                    console.log(err)
                                }
                            });
                        }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\chamber-app-ddd\resources\views/ads/index.blade.php ENDPATH**/ ?>